class tsBaseMutator extends Mutator;

//game vars:
var DeathMatchPlus MyGame;
var bool bInit;

function PostBeginPlay() 
{

	MyGame = DeathMatchPlus(Level.Game);

	Super.PostBeginPlay();

	AddMutator(Level.Spawn(class'u4e_DMstats'));
}


function bool AlwaysKeep(Actor Other) 
{
	
	local Mover mov;
	local bool bExists;
	
/*	if (Other.IsA('TournamentPlayer') || Other.IsA('Bot')) 
        {
		Pawn(Other).PlayerReplicationInfoClass = class'SV_PlayerInfo';
		return true;
	}
*/	

	
	if (Other.IsA('Mover')) 
        {
		if (Mover(Other).InitialState == 'BumpOpenTimed'
			|| Mover(Other).InitialState == 'StandOpenTimed')
			Mover(Other).BumpType = BT_PawnBump;
	}
	
	bExists = false;
	if (Other.IsA('Trigger')) 
        {
		foreach AllActors (class'Mover', mov, Other.Event)
			bExists = True;
		if (bExists && Trigger(Other).TriggerType == TT_PlayerProximity)
			Trigger(Other).TriggerType = TT_PawnProximity;
		return true;
	}
	
	if (NextMutator != None)
		return (NextMutator.AlwaysKeep(Other));
	
	return false;
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant) 
{	
	
	if (MyGame.bMegaSpeed && Other.bIsPawn && Pawn(Other).bIsPlayer) 
        	{
		Pawn(Other).GroundSpeed *= 1.4;
		Pawn(Other).WaterSpeed *= 1.4;
		Pawn(Other).AirSpeed *= 1.4;
		Pawn(Other).AccelRate *= 1.4;
		}
	
	if (Other.IsA('Weapon')) 
        	{
		
		if (Other.IsA('TournamentWeapon'))
			return true;
		
		if (Other.IsA('Stinger')) 
                {
			ReplaceWith(Other, "Botpack.PulseGun");
			return false;
		}
		
		return true;
		}
	
	if (Other.IsA('Ammo')) 
        {
		
		if (Other.IsA('TournamentAmmo'))
			return true;
		
		if (Other.IsA('ASMDAmmo')) 
                {
			ReplaceWith(Other, "Botpack.ShockCore");
			return false;
		}
		
		return true;
	}
		


	bSuperRelevant = 0;
	return true;
}

defaultproperties
{
}
